/*******************************************************
Filename		:  	DW_result_hub_custom.sql
Release 		:  	STORET c2.0, C2.0.1
SIR			:  	1446, 1560, 1557
Description		:  	Gatekeeper procedure that produces a shell HTML page
				and calls the procedure to generate a report or view a list
				of stations based on the user selection.
Author			:  	Joseph Wilson
Date			: 	March 4, 2003 --changed table type to vc_arr
                  	:     	April 30, 2003 - Pass the number '7' to the footer to be used to bookmark Help - W.Nash
			:	June 27, 2003 - Pass HINTS for report creation -JW
				July 22, 2003 - pass report type -JW
                        	08/15/2003 - Removed 'BETA' from the page title. -CT
				10/14/2003 - Added report filesize estimates (SIR 1560)-JW
                        11/04/2003 - Updated to allow file to be gzipped. (SIR 1557)-CT
                        11/13/2003 - Removed zip file question; changed button label. -CT
Comments		:  	Displays a link to the report file created by the report generating
				procedure.  
**********************************************************/

CREATE OR REPLACE PROCEDURE DW_Result_Hub_Custom
(v_FromStmt		IN	VARCHAR2,
v_WhereStmt		IN 	VARCHAR2,
v_ResultCount		IN 	VARCHAR2,
v_rule_optimization	IN	VARCHAR2,
v_report_type		IN	CHAR,
v_Columns 		owa_util.vc_arr,
--v_ActColumns	owa_util.ident_arr,
report_type 		varchar2 :='CUSTOM'
)
AS

v_exists 		boolean;
v_file_length 		number;
v_blocksize 		number;

program_path  		varchar2(1000) := null;
script_path   		varchar2(1000) := null;
image_path    		varchar2(1000) := null;
page_title    		varchar2(100);
--
--The out_file variable will contain the entire URL of the file created within 
--the called download procedures.
--
out_file	  	varchar2(200);

BEGIN
	page_title :='Download Results';
	DW_TOP_OF_PAGE(page_title, program_path, script_path, image_path);
      htp.print('<form action="DW_result_download_zip" method=POST>');
	htp.para;
	htp.para;
	htp.para;
	htp.print('<center>');
	IF report_type = 'CUSTOM' THEN
		htp.print('You have requested to download monitoring Results');
		--DW_result_download_custom(v_FromStmt,v_WhereStmt,v_Columns,v_ActColumns,'NONE',out_file);
		DW_result_download_custom(v_FromStmt,v_WhereStmt,v_rule_optimization,v_report_type,v_Columns,'NONE',out_file);
	END IF;
	htp.Br;
	htp.Br;
	htp.Br;
	htp.anchor(out_file,htf.bold('Download your file now...'));
	utl_file.fgetattr(DW_GLOB_VAR.lv_iodir,out_file,v_exists,v_file_length,v_blocksize);
	htp.print('<br><br>The size of your report download is '||ROUND(v_file_length/1024,1)||'KB');

--      htp.print('<br><br><B>Create report download in zip format? &nbsp &nbsp </B>');
	htp.Br;
	htp.Br;
	htp.Br;
      htp.print('<input type="button" value="Compress Data File now" width=40 onClick="javascript:document.forms[1].submit();">');
	htp.print('</center>');
      htp.print('<input type="hidden" name="out_file" value='||out_file||'>');

	htp.print('</center>');
	DW_bottom_of_page(7);

END;
/
show errors